(function(exports) {


exports.set_boards_count = function(product_code_arr)
{
	if (product_code_arr[0] == common.MODEL_CODE().EM_12 && product_code_arr[1] == 4) // EM-12T
	{
		configuration.boards_count = 7
	}
}

exports.show_boards_types_setting = function()
{
	let table = $('<table>').addClass('data_td').addClass('nowrap_td')
	table.append(common.form_tag_tr(l100n.localize_string("main_board"), 0x1027, 1))
	for (number = 1; number <= configuration.boards_count; number++)
	{
		table.append(common.form_tag_tr(l100n.localize_string(`board_${number}`), 0x1027, number+1))
	}
	
	let board_head = $('<div>').append(l100n.localize_string("Boards_Types")).addClass("accordion-header")
	let board_body = $('<div>').addClass("accordion-body").append(table)

	$("#boards_types_setting").append(board_head).append(board_body)
}

exports.show_boards_by_type = function(types, product_code_arr) {
$("#io_settings").append('<h3 id="Boards_Settings">I/O Boards Settings</h3>')

if (product_code_arr[0] == common.MODEL_CODE().EM_12 || product_code_arr[0] == common.MODEL_CODE().EM_02) // show board 0
{
	const board_index = "3F01:1"
	let ul = $('#device_info_ul')
	let table = $('#device_info_table')
	let board_status = $('<div>').addClass('tag').addClass('board_status').attr({"index": board_index}).hide()
	let board_body = $('<div>').addClass("accordion-body").append(board_status)
	let board_div = $('<div>').addClass("board").attr({"id": `board_0`}).append(board_body)
    let tab_body = $(`<tbody id="board_head">`).append(board_div).addClass('nowrap_td').addClass('data_td')

	ul.append($(`<li><a href="#board_head">${l100n.localize_string("head_module_tab")}</a></li>`))
    table.append(tab_body)
	$("#board_8").hide()
}

for (let board_number = 0; board_number < configuration.boards_count+1; board_number++)
{
//console.log("board_number "+board_number);
//console.log("types[board_number] "+types[board_number])
if (types[board_number] != null)
{
	let type = types[board_number].replace(/\u0000/g, '')
	let board_name = ""

	if ((board_number > 0) ||
		(type == common.board_types.hcr12f_a_mb) ||
		(type == common.board_types.hcr12f_d_mb))
	{
		let board_code = ''
		let board_index = (0x4001 + (board_number - 1)*0x100).toString(16).toUpperCase()
		let board_div = $('<div>').addClass("board").attr({"id": `board_${board_number}`})
		if ((type == common.board_types.hcr12f_a_mb) ||
			(type == common.board_types.hcr12f_d_mb))
		{
			board_name = l100n.localize_string("main_board")
		}
		else
		{
			board_name = `${l100n.localize_string("module")} ${board_number}`
		}
		
		let board_name_div = $('<div>').text(board_name).addClass('board_name').addClass('board_name_div')
		if (product_code_arr[0] == common.MODEL_CODE().EM_02) {
			let eds_index = 0x4000 + (board_number - 1)*0x100;
			board_code = $('<div>').addClass("tag").attr({"index": `${eds_index.toString(16).toUpperCase()}:1`}).addClass('board_name')
		}
		else
		{
			$.each(templates_commands.module_types_all(), function(index, item)
			{
				if (item.command == type)
				{
					board_code = item.name
					return false;
				}
			})
			if ((type == common.board_types.hcr12f_a_mb) ||
				(type == common.board_types.hcr12f_d_mb))
			{
				$.each(templates_commands.head_types_all(), function(index, item)
				{
					if (item.command == type)
					{
						board_code = item.name
						return false;
					}
				})
			}
		}

		let board_name_table = $('<div>').append(board_name_div).append(board_code).addClass('board_name')
		let board_head = $('<div>').append(board_name_table).addClass("accordion-header").attr({"status_index": `${board_index}:1`})
		let board_body = $('<div>').addClass("accordion-body")
	
		let board_status = $('<div>').addClass('tag').addClass('board_status').attr({"index": `${board_index}:1`}).hide()
		board_body.append(board_status);
		board_div.append(board_head);
		board_div.append(board_body);
		$("#io_settings").append(board_div);
	}

	if (type == common.board_types.di || type == common.board_types.hdi)
	{
	    let count = 10;
		if (board_number == 0) count = 5;
		let start_subindex = 1
		
		let tabs_div = di_tab(board_number, start_subindex, count)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)	
	}
	else if ((type == common.board_types.em_h) || (type == common.board_types.em_l))
	{
		let tabs_div = em_tab(board_number, product_code_arr)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == common.board_types.hdo || type == common.board_types.ro)
	{
		let count = 10;
		if (type == common.board_types.ro)
		{
			count = 4;
		}
		if (board_number == 0) count = 5;
		
		let tabs_div = do_tab(board_number, 1, count)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)	
	}
	else if (type == common.board_types.ai)
	{
		let tabs_div = ai_tab(type, board_number, 1, 8, templates_commands.sensor_type_ai())
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == common.board_types.cti)
	{
		let tabs_div = ai_tab(type, board_number, 1, 8)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == common.board_types.ti)
	{
		let tabs_div = ai_tab(type, board_number, 1, 4, templates_commands.sensor_type_ti())
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == common.board_types.rtd)
	{
		let tabs_div = ai_tab(type, board_number, 1, 4, templates_commands.sensor_type_rtd_400_ohm())
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == common.board_types.vi)
	{
		let tabs_div = ai_tab(type, board_number, 1, 8, null, null, false)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == common.board_types.ao2)
	{
		let tabs_div = ao_tab(board_number, 1, 2)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == common.board_types.ao4)
	{
		let tabs_div = ao_tab(board_number, 1, 4)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == common.board_types.f_io)
	{
		ul = $('<ul>')
		ul.append($('<li>').append($('<a>').prop('href',`#rtd_tab_${board_number}`).append("RTD")))
		let tbody_rtd = $('<tbody>').prop('id',`rtd_tab_${board_number}`).append(ai_tab(type, board_number, 5, 1, templates_commands.sensor_type_mcu_f()))
		ul.append($('<li>').append($('<a>').prop('href',`#ai_tab_${board_number}`).append("AI")))
		let tbody_ai = $('<tbody>').prop('id',`ai_tab_${board_number}`).append(ai_tab(type, board_number, 7, 1, templates_commands.sensor_type_ai()))
		ul.append($('<li>').append($('<a>').prop('href',`#cti_1_tab_${board_number}`).append("CTI-1")))
		let tbody_cti_1 = $('<tbody>').prop('id',`cti_1_tab_${board_number}`).append(ai_tab(type, board_number, 1, 1, null, "mA"))
		ul.append($('<li>').append($('<a>').prop('href',`#cti_2_tab_${board_number}`).append("CTI-2")))
		let tbody_cti_2 = $('<tbody>').prop('id',`cti_2_tab_${board_number}`).append(ai_tab(type, board_number, 3, 1, null, "µA"))
		ul.append($('<li>').append($('<a>').prop('href',`#di_tab_${board_number}`).append("DI")))
		let tbody_di = $('<tbody>').prop('id',`di_tab_${board_number}`).append(di_tab(board_number, 1, 4))
		ul.append($('<li>').append($('<a>').prop('href',`#do_tab_${board_number}`).append("DO")))
		let tbody_do = $('<tbody>').prop('id',`do_tab_${board_number}`).append(do_tab(board_number, 1, 2))

		let tab_table = $('<table>')
		tab_table.append(tbody_ai).append(tbody_cti_1).append(tbody_cti_2).append(tbody_rtd).append(tbody_di).append(tbody_do)

		let main_div = $('<div>').addClass('tab-class');
	    main_div.append(ul).append(tab_table)
	    $(`#board_${board_number}`).children('.accordion-body').append(main_div);
	}
	else if (type == common.board_types.f_lcd)
	{
		$(`#board_${board_number}`).addClass( "ui-state-disabled" )
	}
	else if (type == common.board_types.hcr12f_cti)
	{
		let count = 12;
		let start_subindex = 1
		let tabs_div = ai_tab(common.board_types.cti, board_number, start_subindex, count)
		$(`#board_${board_number}`).children('.accordion-body').append(tabs_div)
	}
	else if (type == common.board_types.hcr12f_hdo_di)
	{
		ul = $('<ul>')
		ul.append($('<li>').append($('<a>').prop('href',`#hdo_tab_${board_number}`).append("6HDO")))
		let hdo_table = do_tab(board_number, 1, 6)
		let tbody_hdo = $('<tbody>').prop('id',`hdo_tab_${board_number}`).append(hdo_table)
		ul.append($('<li>').append($('<a>').prop('href',`#di_tab_${board_number}`).append("16DI")))
		let di_table = di_tab(board_number, 1, 16, type)
		let tbody_di = $('<tbody>').prop('id',`di_tab_${board_number}`).append(di_table)
		
		let tab_table = $('<table>')
		tab_table.append(tbody_hdo).append(tbody_di)

		let main_div = $('<div>').addClass('tab-class');
	    main_div.append(ul).append(tab_table)
	    $(`#board_${board_number}`).children('.accordion-body').append(main_div);
	}
	else if (type == common.board_types.hcr12f_a_mb || type == common.board_types.hcr12f_d_mb)
	{
		/*const board_index = "3F01"
		let board_status = $('<div>').addClass('tag').addClass('board_status').attr({"index": `${board_index}:1`}).hide()
		let board_body = $('<div>').addClass("accordion-body").append(board_status)
		let board_div = $('<div>').addClass("board").attr({"id": `board_${board_number}`}).append(board_body)
		$("#board_head").append(board_div)*/
		
		ul = $('<ul>')
		ul.append($('<li>').append($('<a>').prop('href',`#hdo_tab_${board_number}`).append("HDO")))
		let hdo_table = do_tab(board_number, 1, 1)
		let tbody_hdo = $('<tbody>').prop('id',`hdo_tab_${board_number}`).append(hdo_table)
		ul.append($('<li>').append($('<a>').prop('href',`#ai_tab_${board_number}`).append("3VI")))
		let ai_table = ai_tab(type, board_number, 1, 3, null, "V", false)
		let tbody_ai = $('<tbody>').prop('id',`ai_tab_${board_number}`).append(ai_table)
		ul.append($('<li>').append($('<a>').prop('href',`#rtd_tab_${board_number}`).append("RTD")))
		let rtd_table = ai_tab(common.board_types.rtd, board_number, 4, 1,
			 templates_commands.sensor_type_rtd_hc_12(), "gradC", false)
		let tbody_rtd = $('<tbody>').prop('id',`rtd_tab_${board_number}`).append(rtd_table)
	
		let tab_table = $('<table>')
		tab_table.append(tbody_hdo).append(tbody_ai).append(tbody_rtd)
	
		let main_div = $('<div>').addClass('tab-class');
		main_div.append(ul).append(tab_table)
	
		$(`#board_${board_number}`).children('.accordion-body').append(main_div)
	}
    else if (type == common.board_types.deleted)
    {
		$(`#board_${board_number}`).hide();
    }
    else
    {
		$(`#board_${board_number}`).hide();
	}
}
else
{
	if (board_number != 0)
	{
		$(`#board_${board_number}`).hide();
	}
}
}
}

function di_tab(board_number, start_subindex, count, type=null)
{
	let ul = $('<ul>')
	ul.append($(`<li><a href="#value-tab${board_number}">${l100n.localize_string("input state")}</a></li>`))
	ul.append($(`<li><a href="#settings-tab${board_number}">${l100n.localize_string("Settings")}</a></li>`))

	let value_tab = $(`<tbody id="value-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	let settings_tab = $(`<tbody id="settings-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')

	let value_header = $('<tr>').addClass('table_header')
	value_header.append($('<td colspan="1">'))//.text(l100n.localize_string("Channel:")))
	value_header.append($('<td colspan="1">').text(l100n.localize_string("value")))
	value_header.append($('<td colspan="1">').text(l100n.localize_string("invert_polarity")))
	value_tab.append(value_header)

	if (type == common.board_types.hcr12f_hdo_di)
	{
		let wet_dry_contact_header = $('<tr>').addClass('table_header')
		wet_dry_contact_header.append($('<td colspan="3">').text(l100n.localize_string("wet_dry_header")))
		settings_tab.append(wet_dry_contact_header)

		let wet_dry_contact = {name: l100n.localize_string("wet_dry_contact"), index: 0x3F19 + board_number*0x100, sub: 1}
		settings_tab.append(common.form_tag_tr_param(wet_dry_contact));
	}

	let settings_table = $('<table>')

	let settings_header = $('<tr>').addClass('table_header')
	settings_header.append($('<td colspan="1">'))//.text(l100n.localize_string("Channel:")))
	settings_header.append($('<td colspan="1">').text(l100n.localize_string("invert_polarity")))
	settings_header.append($('<td colspan="1">').text(l100n.localize_string("Filter time, ms")))
	settings_table.append(settings_header)

	for (let eds_subindex = start_subindex; eds_subindex < start_subindex+count; eds_subindex++)
	{
		let channel_number = eds_subindex - start_subindex + 1
		let value_params = {name: `${channel_number}`, index: 0x3F11 + board_number*0x100, sub: eds_subindex, type: "boolean_input"}
		let invert_params = {name: "", index: 0x3F12 + board_number*0x100, sub: eds_subindex, type: "ro"}
		value_tab.append(common.form_tag_tr2_param(value_params, invert_params));

		let invert2_params = {name: `${channel_number}`, index: 0x3F12 + board_number*0x100, sub: eds_subindex}
		let filter_time_params = {name: "", index: 0x3F13 + board_number*0x100, sub: eds_subindex}
		settings_table.append(common.form_tag_tr2_param(invert2_params, filter_time_params));
	}
	settings_tab.append(settings_table)

	let table = $('<table>').append(value_tab).append(settings_tab)
	let tabs_div = $('<div class="tab-class">').append(ul).append(table)

	return tabs_div
}

function do_tab(board_number, start_subindex, count)
{
	var ul = $('<ul>')
	ul.append($(`<li><a href="#value-tab${board_number}">${l100n.localize_string("output state")}</a></li>`))
	ul.append($(`<li><a href="#invert_polarity-tab${board_number}">${l100n.localize_string("Settings")}</a></li>`))
	ul.append($(`<li><a href="#error_mode-tab${board_number}">${l100n.localize_string("Error mode")}</a></li>`))
	ul.append($(`<li><a href="#filter_mask-tab${board_number}">${l100n.localize_string("Filter mask")}</a></li>`))

	var value_tab = $(`<tbody id="value-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	var invert_polarity_tab = $(`<tbody id="invert_polarity-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	var error_mode_tab = $(`<tbody id="error_mode-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	var filter_mask_tab = $(`<tbody id="filter_mask-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	
	var value_header = $('<tr>').addClass('table_header')
	value_header.append($('<td colspan="1">'))//.text(l100n.localize_string("Channel:")))
	value_header.append($('<td colspan="1">').text(l100n.localize_string("value")))
	value_header.append($('<td colspan="1">').text(l100n.localize_string("invert_polarity")))
	value_tab.append(value_header)
	var error_mode_header = $('<tr>').addClass('table_header')
	error_mode_header.append($('<td colspan="1">'))
	error_mode_header.append($('<td colspan="1">').text(l100n.localize_string("Error value")))
	error_mode_header.append($('<td colspan="1">').text(l100n.localize_string("Error mode")))
	error_mode_tab.append(error_mode_header)
	invert_polarity_tab.append($('<tr>').addClass('table_header').append($('<td colspan="1">')).append($('<td colspan="1">').text(l100n.localize_string("invert_polarity"))))
	filter_mask_tab.append($('<tr>').addClass('table_header').append($('<td colspan="1">')).append($('<td colspan="1">').text(l100n.localize_string("Filter mask"))))

	for (var eds_subindex = start_subindex; eds_subindex < start_subindex+count; eds_subindex++)
	{
		var channel_number = eds_subindex - start_subindex + 1
		var value_params = {name: `${channel_number}`, index: 0x3F21 + board_number*0x100, sub: eds_subindex}
		var invert_params = {name: "", index: 0x3F22 + board_number*0x100, sub: eds_subindex, type: "ro"}
		value_tab.append(common.form_tag_tr2_param(value_params, invert_params));
		invert_polarity_tab.append(common.form_tag_tr(`${channel_number}`, 0x3F22 + board_number*0x100, eds_subindex));
		var error_value_params = {name: `${channel_number}`, index: 0x3F24 + board_number*0x100, sub: eds_subindex}
		var error_mode_params = {name: "", index: 0x3F23 + board_number*0x100, sub: eds_subindex}
		
		error_mode_tab.append(common.form_tag_tr2_param(error_value_params, error_mode_params));
		filter_mask_tab.append(common.form_tag_tr(`${channel_number}`, 0x3F25 + board_number*0x100, eds_subindex));
	}

	var table = $('<table>')
	table.append(value_tab).append(invert_polarity_tab).append(error_mode_tab).append(filter_mask_tab)
	var tabs_div = $('<div class="tab-class">').append(ul).append(table)

	return tabs_div
}

function ai_tab(type, board_number, start_subindex, count, sensor_types=null, units=null, show_status=true)
{
	let ul = $('<ul>')
	ul.append($(`<li><a href="#value-tab${board_number}">${l100n.localize_string("input state")}</a></li>`))
	ul.append($(`<li><a href="#deadband_settings-tab${board_number}">${l100n.localize_string("Deadband Settings")}</a></li>`))
	ul.append($(`<li><a href="#settings-tab${board_number}">${l100n.localize_string("Settings")}</a></li>`))
	ul.append($(`<li><a href="#scaling-tab${board_number}">${l100n.localize_string("Scaling")}</a></li>`))
	
	let value_tab = $(`<tbody id="value-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	let scaling = $(`<tbody id="scaling-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	let settings = $(`<tbody id="settings-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	let deadband_settings = $(`<tbody id="deadband_settings-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	
	let value_head = $('<tr>').addClass('table_header');
	value_head.append($('<td colspan="1">').text(""))
	if (units != null)
	{
		value_head.append($('<td colspan="1">')
		.text(`${l100n.localize_string("value")}, ${l100n.localize_string(units)}`))
	}
	else
	{
		value_head.append($('<td colspan="1">').text(l100n.localize_string("value")))
	}
	
	if (show_status)
	{
		if (type == common.board_types.cti)
		{
			value_head.append($('<td colspan="1">').text(l100n.localize_string("Range")))
		}
		else
		{
			value_head.append($('<td colspan="1">').text(l100n.localize_string("Status")))
		}
	}
	value_head.append($('<td colspan="1">').text(l100n.localize_string("Scaled")))
	value_tab.append(value_head)

	let deadband_head = $('<tr>').addClass('table_header');
	deadband_head.append($('<td colspan="1">').text(""));
	deadband_head.append($('<td colspan="1">').text(l100n.localize_string("Deadband Reference")));
	deadband_head.append($('<td colspan="1">').text(l100n.localize_string("Deadband, %")))
	deadband_settings.append(deadband_head)
	let scaling_head = $('<tr>').addClass('table_header').append($('<td colspan="1">').text(""));
	scaling_head.append($('<td colspan="1">').text(l100n.localize_string("Scaling")));
	scaling_head.append($('<td colspan="1">').text(l100n.localize_string("Offset")))
	scaling.append(scaling_head)
	let settings_head = $('<tr>').addClass('table_header').append($('<td colspan="1">').text(""));
	if (sensor_types != null)
	{
		if (type == common.board_types.ai)
		{
			settings_head.append($('<td colspan="1">').text(l100n.localize_string("Input Range")))
		}
		else
		{
			settings_head.append($('<td colspan="1">').text(l100n.localize_string("Input Sensor")))
		}
		
	}
	settings_head.append($('<td colspan="1">').text(l100n.localize_string("Filter time, ms")))
	settings.append(settings_head)

	for (let eds_subindex = start_subindex; eds_subindex < start_subindex+count; eds_subindex++)
	{
		let channel_number = eds_subindex - start_subindex + 1

		value_tab.append(ai_value_tr(channel_number, board_number, eds_subindex, show_status));
		let scaling_tr = common.form_tag_tr2(`${channel_number}`, 0x3F32 + board_number*0x100, eds_subindex, "", 0x3F33 + board_number*0x100, eds_subindex)
		scaling.append(scaling_tr)
		if (sensor_types != null)
		{
			let sensor_index = 0x3F39 + board_number*0x100
			settings.append(common.form_tag_tr2(`${channel_number}`, sensor_index, eds_subindex
				, "", 0x3F34 + board_number*0x100, eds_subindex))
			let template = {"index": `${sensor_index.toString(16).toUpperCase()}_${eds_subindex}`,
							"template": "combobox", 
							"commands": sensor_types}
			configuration.add_template(template)
		}
		else
		{
			settings.append(common.form_tag_tr(`${channel_number}`, 0x3F34 + board_number*0x100, eds_subindex));
		}
		deadband_settings.append(common.form_tag_tr2(`${channel_number}`, 0x3F3C + board_number*0x100, eds_subindex, "", 0x3F35 + board_number*0x100, eds_subindex));

		let mode_index = 0x3F0F + board_number*0x100
		let commands = templates_commands.ai_status()
		if (type == common.board_types.cti)
		{
			commands = templates_commands.leakage_current_mode()
		}
		let template = {"index": `${mode_index.toString(16).toUpperCase()}_${eds_subindex}`,
				"template": "change_value", 
				"commands": commands}
		configuration.add_template(template)
	}

	let table = $('<table>')
	table.append(value_tab).append(deadband_settings).append(settings).append(scaling)//.append(deadband)
	let tabs_div = $('<div class="tab-class">').append(ul).append(table)

	return tabs_div
}

function ai_value_tr(channel_number, board_number, eds_subindex, show_status)
{
	let value_params = {name: `${channel_number}`, index: 0x3F31 + board_number*0x100, sub: eds_subindex}
	let status_params = {name: "", index: 0x3F0F + board_number*0x100, sub: eds_subindex}
	let scaling_params = {"scaling_index": `${(0x3F32 + board_number*0x100).toString(16).toUpperCase()}`, "scaling_sub": eds_subindex}
	let offset_params = {"offset_index": `${(0x3F33 + board_number*0x100).toString(16).toUpperCase()}`, "offset_sub": eds_subindex}

    let tr = $('<tr class="can_hide">').append($('<td>').text(value_params.name))//.addClass("name"));
	let div = $('<div>').addClass("accordion_tag").attr({"index": `${value_params.index.toString(16).toUpperCase()}:${value_params.sub}`})
	if ("type" in value_params)
	{
		div.addClass(value_params.type)
	}
    tr.append($('<td>').append(div))//.addClass("name"))

	if (show_status) 
	{
		let div2 = $('<div>').addClass("accordion_tag").attr({"index": `${status_params.index.toString(16).toUpperCase()}:${status_params.sub}`})
		if ("type" in status_params)
		{
			div2.addClass(status_params.type)
		}
		tr.append($('<td>').append(div2))//.addClass("name"))
	}

	let scaled_div = $('<label><span></span></label>').addClass("readonly_cb")
	scaled_div.addClass("scaled").attr(scaling_params).attr(offset_params)
	tr.append($('<td>').append(scaled_div))
	
    return tr;
}

function ao_tab(board_number, start_subindex, count)
{
	let ul = $('<ul>')
	ul.append($(`<li><a href="#value-tab${board_number}">${l100n.localize_string("output state")}</a></li>`))	
	ul.append($(`<li><a href="#error_mode-tab${board_number}">${l100n.localize_string("Error mode")}</a></li>`))
	//ul.append($(`<li><a href="#error_value-tab${board_number}">${l100n.localize_string("Error value")}</a></li>`))
	ul.append($(`<li><a href="#scaling-tab${board_number}">${l100n.localize_string("Scaling")}</a></li>`))

	let value_tab = $(`<tbody id="value-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	let scaling = $(`<tbody id="scaling-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	let error_mode = $(`<tbody id="error_mode-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	//var error_value = $(`<tbody id="error_value-tab${board_number}">`).addClass('nowrap_td').addClass('data_td')
	
	value_tab.append($('<tr>').addClass('table_header').append($('<td colspan="1">'))
		.append($('<td colspan="1">').text(l100n.localize_string("value")))
		.append($('<td colspan="1">').text(l100n.localize_string("Scaled"))))
	let error_mode_header = $('<tr>').addClass('table_header')
	error_mode_header.append($('<td colspan="1">'))
	error_mode_header.append($('<td colspan="1">').text(l100n.localize_string("Error value")))
	error_mode_header.append($('<td colspan="1">').text(l100n.localize_string("Error mode")))
	error_mode.append(error_mode_header)

	let scaling_head = $('<tr>').addClass('table_header').append($('<td colspan="1">'));
	scaling_head.append($('<td colspan="1">').text(l100n.localize_string("Scaling")));
	scaling_head.append($('<td colspan="1">').text(l100n.localize_string("Offset")))
	scaling.append(scaling_head)

	for (let eds_subindex = start_subindex; eds_subindex < start_subindex+count; eds_subindex++)
	{
		value_tab.append(ao_value_tr(eds_subindex, board_number, eds_subindex));
		scaling.append(common.form_tag_tr2(`${eds_subindex}`, 0x3F43 + board_number*0x100, eds_subindex, "", 0x3F42 + board_number*0x100, eds_subindex));		
		let error_value_params = {name: `${eds_subindex}`, index: 0x3F45 + board_number*0x100, sub: eds_subindex}
		let error_mode_params = {name: "", index: 0x3F44 + board_number*0x100, sub: eds_subindex}
		error_mode.append(common.form_tag_tr2_param(error_value_params, error_mode_params));
	}

	let table = $('<table>')
	table.append(value_tab).append(scaling).append(error_mode)
	let tabs_div = $('<div class="tab-class">').append(ul).append(table)

	return tabs_div
}


function ao_value_tr(channel_number, board_number, eds_subindex)
{
	let value_params = {name: `${channel_number}`, index: 0x3F41 + board_number*0x100, sub: eds_subindex}

	let scaling_params = {"scaling_index": `${(0x3F43 + board_number*0x100).toString(16).toUpperCase()}`, "scaling_sub": eds_subindex}
	let offset_params = {"offset_index": `${(0x3F42 + board_number*0x100).toString(16).toUpperCase()}`, "offset_sub": eds_subindex}


    let tr = $('<tr class="can_hide">').append($('<td>').text(value_params.name))//.addClass("name"));
	let div = $('<div>').addClass("accordion_tag").attr({"index": `${value_params.index.toString(16).toUpperCase()}:${value_params.sub}`})
	if ("type" in value_params)
	{
		div.addClass(value_params.type)
	}
    tr.append($('<td>').append(div))//.addClass("name"))

	let scaled_div = $('<label><span></span></label>').addClass("readonly_cb")
	scaled_div.addClass("scaled").attr(scaling_params).attr(offset_params)
	tr.append($('<td>').append(scaled_div))

    return tr;
}

function em_tab(board_number, product_code_arr)
{
	var main_description = {name: l100n.localize_string("C V PF"), blocks: [
		{
			header: l100n.localize_string("Current"),
			params: [
			{name: "Ia, A ", index: 0x4064 + (board_number-1)*0x100, sub: 1},
			{name: "Ib, A ", index: 0x4064 + (board_number-1)*0x100, sub: 2},
			{name: "Ic, A ", index: 0x4064 + (board_number-1)*0x100, sub: 3},
			{name: "Iavg, A ", index: 0x4064 + (board_number-1)*0x100, sub: 5},
			{name: `Id, ${l100n.localize_string("mA")} `, index: 0x4064 + (board_number-1)*0x100, sub: 4}
		]},
		{
			header: l100n.localize_string("L2N Voltage"),
			params: [
			{name: `Ua, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 1},
			{name: `Ub, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 2},
			{name: `Uc, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 3},
			{name: `Uavg, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 4}
		]},
		{
			header: l100n.localize_string("L2L Voltage"),
			params: [
			{name: `Uab, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 5},
			{name: `Ubc, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 6},
			{name: `Uca, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 7},
			{name: `ULavg, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 8}
		]},
		{
			header: l100n.localize_string("Power Factor"),
			params: [
			{name: "PFa ", index: 0x4066 + (board_number-1)*0x100, sub: 13},
			{name: "PFb ", index: 0x4066 + (board_number-1)*0x100, sub: 14},
			{name: "PFc ", index: 0x4066 + (board_number-1)*0x100, sub: 15},
			{name: "PFavg ", index: 0x4066 + (board_number-1)*0x100, sub: 16}
		]}
	]}
	var power = {name: l100n.localize_string("Power"), blocks: [
		{
			header: l100n.localize_string("Active"),
			params: [
			{name: `Pa, ${l100n.localize_string("kW")} `, index: 0x4066 + (board_number-1)*0x100, sub: 1},
			{name: `Pb, ${l100n.localize_string("kW")} `, index: 0x4066 + (board_number-1)*0x100, sub: 2},
			{name: `Pc, ${l100n.localize_string("kW")} `, index: 0x4066 + (board_number-1)*0x100, sub: 3},
			{name: `P, ${l100n.localize_string("kW")} `, index: 0x4066 + (board_number-1)*0x100, sub: 4}
		]},
		{
			header: l100n.localize_string("Reactive"),
			params: [
			{name: `Qa, ${l100n.localize_string("kvar")} `, index: 0x4066 + (board_number-1)*0x100, sub: 5},
			{name: `Qb, ${l100n.localize_string("kvar")} `, index: 0x4066 + (board_number-1)*0x100, sub: 6},
			{name: `Qc, ${l100n.localize_string("kvar")} `, index: 0x4066 + (board_number-1)*0x100, sub: 7},
			{name: `Q, ${l100n.localize_string("kvar")} `, index: 0x4066 + (board_number-1)*0x100, sub: 8}
		]},
		{
			header: l100n.localize_string("Apparent"),
			params: [
			{name: `Sa, ${l100n.localize_string("kVA")} `, index: 0x4066 + (board_number-1)*0x100, sub: 9},
			{name: `Sb, ${l100n.localize_string("kVA")} `, index: 0x4066 + (board_number-1)*0x100, sub: 10},
			{name: `Sc, ${l100n.localize_string("kVA")} `, index: 0x4066 + (board_number-1)*0x100, sub: 11},
			{name: `S, ${l100n.localize_string("kVA")} `, index: 0x4066 + (board_number-1)*0x100, sub: 12}
		]}
	]}
	/*var energy = {name: l100n.localize_string("Energy"), blocks: [
		{
			header: l100n.localize_string("Active"),
			params: [
			{name: `Wa+, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 2},
			{name: `Wb+, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 3},
			{name: `Wc+, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 4},
			{name: `W+, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 5}
		]},
		{
			header: l100n.localize_string("Active"),
			params: [
			{name: `Wa-, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 6},
			{name: `Wb-, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 7},
			{name: `Wc-, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 8},
			{name: `W-, ${l100n.localize_string("kWh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 9}
		]},
		{
			header: l100n.localize_string("Reactive"),
			params: [
			{name: `WQa+, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 10},
			{name: `WQb+, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 11},
			{name: `WQc+, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 12},
			{name: `WQ+, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 13}
		]},
		{
			header: l100n.localize_string("Reactive"),
			params: [
			{name: `WQa-, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 14},
			{name: `WQb-, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 15},
			{name: `WQc-, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 16},
			{name: `WQ-, ${l100n.localize_string("kvarh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 17}
		]},
		{
			header: l100n.localize_string("Apparent"),
			params: [
			{name: `WSa, ${l100n.localize_string("kVAh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 18},
			{name: `WSb, ${l100n.localize_string("kVAh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 19},
			{name: `WSc, ${l100n.localize_string("kVAh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 20},
			{name: `WS, ${l100n.localize_string("kVAh")}`, index: 0x4067 + (board_number-1)*0x100, sub: 21}
		]}
	]}*/
	var energy = {name: l100n.localize_string("Energy"), blocks: [
		{
			header: l100n.localize_string("Active"),
			params: [
			{name: `Wa+`, index: 0x4067 + (board_number-1)*0x100, sub: 2},
			{name: `Wb+`, index: 0x4067 + (board_number-1)*0x100, sub: 3},
			{name: `Wc+`, index: 0x4067 + (board_number-1)*0x100, sub: 4},
			{name: `W+`, index: 0x4067 + (board_number-1)*0x100, sub: 5}
		]},
		{
			header: l100n.localize_string("Active"),
			params: [
			{name: `Wa-`, index: 0x4067 + (board_number-1)*0x100, sub: 6},
			{name: `Wb-`, index: 0x4067 + (board_number-1)*0x100, sub: 7},
			{name: `Wc-`, index: 0x4067 + (board_number-1)*0x100, sub: 8},
			{name: `W-`, index: 0x4067 + (board_number-1)*0x100, sub: 9}
		]},
		{
			header: l100n.localize_string("Reactive"),
			params: [
			{name: `WQa+`, index: 0x4067 + (board_number-1)*0x100, sub: 10},
			{name: `WQb+`, index: 0x4067 + (board_number-1)*0x100, sub: 11},
			{name: `WQc+`, index: 0x4067 + (board_number-1)*0x100, sub: 12},
			{name: `WQ+`, index: 0x4067 + (board_number-1)*0x100, sub: 13}
		]},
		{
			header: l100n.localize_string("Reactive"),
			params: [
			{name: `WQa-`, index: 0x4067 + (board_number-1)*0x100, sub: 14},
			{name: `WQb-`, index: 0x4067 + (board_number-1)*0x100, sub: 15},
			{name: `WQc-`, index: 0x4067 + (board_number-1)*0x100, sub: 16},
			{name: `WQ-`, index: 0x4067 + (board_number-1)*0x100, sub: 17}
		]},
		{
			header: l100n.localize_string("Apparent"),
			params: [
			{name: `WSa`, index: 0x4067 + (board_number-1)*0x100, sub: 18},
			{name: `WSb`, index: 0x4067 + (board_number-1)*0x100, sub: 19},
			{name: `WSc`, index: 0x4067 + (board_number-1)*0x100, sub: 20},
			{name: `WS`, index: 0x4067 + (board_number-1)*0x100, sub: 21}
		]}
	]}
	var quality = {name: l100n.localize_string("Quality"), blocks: [
		{
			header: l100n.localize_string("Frequency"),
			params: [
			{name: `F, ${l100n.localize_string("Hz")} `, index: 0x4068 + (board_number-1)*0x100, sub: 1}
		]},
		{
			header: l100n.localize_string("THD Current"),
			params: [
				{name: "THD Ia, % ", index: 0x4068 + (board_number-1)*0x100, sub: 6},
				{name: "THD Ib, % ", index: 0x4068 + (board_number-1)*0x100, sub: 7},
				{name: "THD Ic, % ", index: 0x4068 + (board_number-1)*0x100, sub: 8},
				{name: "THD Iavg, % ", index: 0x4068 + (board_number-1)*0x100, sub: 9}
		]},
		{
			header: l100n.localize_string("THD Voltage"),
			params: [
				{name: "THD Ua, % ", index: 0x4068 + (board_number-1)*0x100, sub: 2},
				{name: "THD Ub, % ", index: 0x4068 + (board_number-1)*0x100, sub: 3},
				{name: "THD Uc, % ", index: 0x4068 + (board_number-1)*0x100, sub: 4},
				{name: "THD Uavg, % ", index: 0x4068 + (board_number-1)*0x100, sub: 5}
		]},
		/*{params: [
			{name: `U1, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 9},
			{name: `U2, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 10},
			{name: `U0, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 11},
			{name: "KU2, %: ", index: 0x4065 + (board_number-1)*0x100, sub: 12},
			{name: "KU0, %: ", index: 0x4065 + (board_number-1)*0x100, sub: 13}
		]}*/
	]}

	var ul = $('<ul>')
	ul.append($(`<li><a href="#em_main_description-tab${board_number}">${main_description.name}</a></li>`))
	ul.append($(`<li><a href="#em_power-tab${board_number}">${power.name}</a></li>`))
	ul.append($(`<li><a href="#em_energy-tab${board_number}">${energy.name}</a></li>`))
	ul.append($(`<li><a href="#em_quality-tab${board_number}">${quality.name}</a></li>`))	
	ul.append($(`<li><a href="#em_statistics-tab${board_number}">${l100n.localize_string("Statistics")}</a></li>`))
	ul.append($(`<li><a href="#em_db_settings-tab${board_number}">${l100n.localize_string("Deadband Settings")}</a></li>`))
	ul.append($(`<li><a href="#em_settings-tab${board_number}">${l100n.localize_string("Settings")}</a></li>`))
	
	var em_settings_tbody = $(`<tbody id="em_settings-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
	var em_db_settings_tbody = $(`<tbody id="em_db_settings-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
	var em_main_description_tbody = $(`<tbody id="em_main_description-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
	var em_power_tbody = $(`<tbody id="em_power-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
	var em_energy_tbody = $(`<tbody id="em_energy-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
	var em_quality_tbody = $(`<tbody id="em_quality-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')
	var em_statistics_tbody = $(`<tbody id="em_statistics-tab${board_number}">`).addClass('data_td').addClass('nowrap_td')

	em_settings_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Scheme"))))
	em_settings_tbody.append(common.form_tag_tr(l100n.localize_string("Scheme"), 0x4060 + (board_number-1)*0x100, 1));
	em_settings_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Current ranges"))))
	em_settings_tbody.append(common.form_tag_tr(l100n.localize_string("Current range"), 0x4060 + (board_number-1)*0x100, 2));
	em_settings_tbody.append(common.form_tag_tr(l100n.localize_string("Current range Lkg"), 0x4060 + (board_number-1)*0x100, 3));
	em_settings_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Transformation ratios"))))
	em_settings_tbody.append(common.form_tag_divide_tr(l100n.localize_string("CTR"), 0x4060 + (board_number-1)*0x100, 4, 0x4060 + (board_number-1)*0x100, 5));
	em_settings_tbody.append(common.form_tag_divide_tr(l100n.localize_string("CTR Lkg"), 0x4060 + (board_number-1)*0x100, 6, 0x4060 + (board_number-1)*0x100, 7));
	em_settings_tbody.append(common.form_tag_divide_tr(l100n.localize_string("VTR"), 0x4060 + (board_number-1)*0x100, 8, 0x4060 + (board_number-1)*0x100, 9));

	var table_head = $('<tr>').addClass('table_header');
	table_head.append($('<td colspan="1">').text(""));
	table_head.append($('<td colspan="1">').text(l100n.localize_string("Deadband Reference")));
	table_head.append($('<td colspan="1">').text(l100n.localize_string("Deadband, %")))
	em_db_settings_tbody.append(table_head)
	em_db_settings_tbody.append(common.form_tag_tr2("Ia, Ib, Ic, A ", 0x4072 + (board_number-1)*0x100, 1, "", 0x406E + (board_number-1)*0x100, 1));
	em_db_settings_tbody.append(common.form_tag_tr2("Id, A ", 0x4072 + (board_number-1)*0x100, 2, "", 0x406E + (board_number-1)*0x100, 2));
	em_db_settings_tbody.append(common.form_tag_tr2(`U, ${l100n.localize_string("V")} `, 0x4073 + (board_number-1)*0x100, 1, "", 0x406F + (board_number-1)*0x100, 1));
	em_db_settings_tbody.append(common.form_tag_tr2(`P, ${l100n.localize_string("kW")}/ Q, ${l100n.localize_string("kvar")}/ S, ${l100n.localize_string("kVA")} `,
												 0x4074 + (board_number-1)*0x100, 1, "", 0x4070 + (board_number-1)*0x100, 1));
	em_db_settings_tbody.append(common.form_tag_tr2("PF ", 0x4074 + (board_number-1)*0x100, 3, "", 0x4070 + (board_number-1)*0x100, 2));
	em_db_settings_tbody.append(common.form_tag_tr2(`F, ${l100n.localize_string("Hz")} `, 0x4075 + (board_number-1)*0x100, 1, "", 0x4071 + (board_number-1)*0x100, 1));
	em_db_settings_tbody.append(common.form_tag_tr2("THD I, % ", 0x4075 + (board_number-1)*0x100, 2, "", 0x4071 + (board_number-1)*0x100, 2));
	em_db_settings_tbody.append(common.form_tag_tr2("THD U, % ", 0x4075 + (board_number-1)*0x100, 2, "", 0x4071 + (board_number-1)*0x100, 3));

	let k_tr = $('<tr class="can_hide">').append($('<td>').text(("K, % ")))
	let k_div = $('<div>').addClass("accordion_tag").attr({"index": `${(0x4071 + (board_number-1)*0x100).toString(16).toUpperCase()}:${3}`});
    k_tr
		.append($('<td>').append("100.00000"))
		.append($('<td>').append(k_div))

	em_db_settings_tbody.append(k_tr)
	
	em_main_description_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="5">').text(main_description.blocks[0].header)))
	em_main_description_tbody.append(common.form_tag_tr_param(main_description.blocks[0].params[0]))
	em_main_description_tbody.append(common.form_tag_tr_param(main_description.blocks[0].params[1]))
	em_main_description_tbody.append(common.form_tag_tr_param(main_description.blocks[0].params[2]))
	em_main_description_tbody.append(common.form_tag_tr_param(main_description.blocks[0].params[3]))
	em_main_description_tbody.append(common.form_tag_tr_param(main_description.blocks[0].params[4]))
	var main_description_head = $('<tr>').addClass('table_header');
	main_description_head.append($('<td colspan="2">').text(main_description.blocks[1].header))
	main_description_head.append($('<td colspan="2">').text(main_description.blocks[2].header))
	em_main_description_tbody.append(main_description_head)
	em_main_description_tbody.append(common.form_tag_tr2_param(main_description.blocks[1].params[0], main_description.blocks[2].params[0]));
	em_main_description_tbody.append(common.form_tag_tr2_param(main_description.blocks[1].params[1], main_description.blocks[2].params[1]));
	em_main_description_tbody.append(common.form_tag_tr2_param(main_description.blocks[1].params[2], main_description.blocks[2].params[2]));
	em_main_description_tbody.append(common.form_tag_tr2_param(main_description.blocks[1].params[3], main_description.blocks[2].params[3]));
	em_main_description_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="5">').text(main_description.blocks[3].header)))
	em_main_description_tbody.append(common.form_tag_tr_param(main_description.blocks[3].params[0]))
	em_main_description_tbody.append(common.form_tag_tr_param(main_description.blocks[3].params[1]))
	em_main_description_tbody.append(common.form_tag_tr_param(main_description.blocks[3].params[2]))
	em_main_description_tbody.append(common.form_tag_tr_param(main_description.blocks[3].params[3]))
	
	mcu_common.create_block(em_power_tbody, power)
	
	//if (product_code_arr[0] == common.MODEL_CODE().EM_02) { 
		var em_energy_profile_link = ($(`<a href="energy_profiles.html?module=${board_number}" target="_blank" id="energy_profiles_${board_number}">`))
		em_energy_profile_link.text(l100n.localize_string("Energy Profiles"))
		var tr_em_energy_profile_link = $('<tr class="can_hide">').append(em_energy_profile_link)
		em_energy_tbody.append(tr_em_energy_profile_link)
	//}
	em_energy_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="4">').text(energy.blocks[0].header)))
	em_energy_tbody.append(common.form_tag_tr2_param(energy.blocks[0].params[0], energy.blocks[1].params[0]));
	em_energy_tbody.append(common.form_tag_tr2_param(energy.blocks[0].params[1], energy.blocks[1].params[1]));
	em_energy_tbody.append(common.form_tag_tr2_param(energy.blocks[0].params[2], energy.blocks[1].params[2]));
	em_energy_tbody.append(common.form_tag_tr2_param(energy.blocks[0].params[3], energy.blocks[1].params[3]));
	em_energy_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="4">').text(energy.blocks[2].header)))
	em_energy_tbody.append(common.form_tag_tr2_param(energy.blocks[2].params[0], energy.blocks[3].params[0]));
	em_energy_tbody.append(common.form_tag_tr2_param(energy.blocks[2].params[1], energy.blocks[3].params[1]));
	em_energy_tbody.append(common.form_tag_tr2_param(energy.blocks[2].params[2], energy.blocks[3].params[2]));
	em_energy_tbody.append(common.form_tag_tr2_param(energy.blocks[2].params[3], energy.blocks[3].params[3]));
	em_energy_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="4">').text(energy.blocks[4].header)))
	em_energy_tbody.append(common.form_tag_tr_param(energy.blocks[4].params[0]))
	em_energy_tbody.append(common.form_tag_tr_param(energy.blocks[4].params[1]))
	em_energy_tbody.append(common.form_tag_tr_param(energy.blocks[4].params[2]))
	em_energy_tbody.append(common.form_tag_tr_param(energy.blocks[4].params[3]))
	em_energy_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="4">').text(l100n.localize_string("Pulse Qty"))))
	var td1_pulsQty = $('<td>').text(`pulsQty, ${l100n.localize_string("kWh")}/${l100n.localize_string("kvarh")}/${l100n.localize_string("kVAh")} `)
	var td2_pulsQty = $('<td>').append($('<div>').addClass("io").addClass("accordion_tag").attr({"index": "4067:1"}))
	var tr_pulsQty = $('<tr class="can_hide">').append(td1_pulsQty).append(td2_pulsQty)
	em_energy_tbody.append(tr_pulsQty)
	var em_energy_button = ($(`<input type="submit" value="${l100n.localize_string("COMMAND_CLEAR_ENERGY")}" id="COMMAND_CLEAR_ENERGY" board_number="${board_number}">`))
	var tr_em_energy_button = $('<tr class="can_hide">').append(em_energy_button)
	em_energy_tbody.append(tr_em_energy_button)	

	mcu_common.create_block(em_quality_tbody, quality)

	em_statistics_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Symmetrical components"))))
	em_statistics_tbody.append(common.form_tag_tr_param({name: `U1, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 9}))
	em_statistics_tbody.append(common.form_tag_tr_param({name: `U2, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 10}))
	em_statistics_tbody.append(common.form_tag_tr_param({name: `U0, ${l100n.localize_string("V")} `, index: 0x4065 + (board_number-1)*0x100, sub: 11}))
	em_statistics_tbody.append(common.form_tag_tr_param({name: "KU2, % ", index: 0x4065 + (board_number-1)*0x100, sub: 12}))
	em_statistics_tbody.append(common.form_tag_tr_param({name: "KU0, % ", index: 0x4065 + (board_number-1)*0x100, sub: 13}))
	em_statistics_tbody.append($('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("Operating Hours"))))
	em_statistics_tbody.append(common.form_tag_tr(`${l100n.localize_string("Operating Hours")} A`, 0x4069 + (board_number-1)*0x100, 1));
	em_statistics_tbody.append(common.form_tag_tr(`${l100n.localize_string("Operating Hours")} B`, 0x4069 + (board_number-1)*0x100, 2));
	em_statistics_tbody.append(common.form_tag_tr(`${l100n.localize_string("Operating Hours")} C`, 0x4069 + (board_number-1)*0x100, 3));
	em_statistics_tbody.append(common.form_tag_tr(l100n.localize_string("Total Operating Hours"), 0x4069 + (board_number-1)*0x100, 4));
	var em_statistics_button = ($(`<input type="submit" value="${l100n.localize_string("COMMAND_CLEAR_MTHRS")}" id="COMMAND_CLEAR_MTHRS" board_number="${board_number}">`))
	em_statistics_tbody.append(em_statistics_button)

	let table = $('<table>')
	table.append(em_main_description_tbody).append(em_power_tbody).append(em_energy_tbody).append(em_quality_tbody).append(em_settings_tbody).append(em_db_settings_tbody).append(em_statistics_tbody)
	let tabs_div = $('<div class="tab-class">').append(ul).append(table)

	return tabs_div
}

exports.create_block = function(table_inner, data)
{
    $.each(data.blocks, function(block_index, block_item)
    {
		var hr = $('<tr class="table_header">').append($('<td  colspan="2">').text(block_item.header).addClass("name"));
		
		table_inner.append(hr);
        $.each(block_item.params, function(param_index, param_item)
        {
            if (param_item.index != null && param_item.sub != null)
            {
                table_inner.append(common.form_tag_tr_param(param_item));
            }
            else
            {
                table_inner.append(form_name_tr(param_item.name));
            }
        })
    })
}

exports.request_board_types = function()
{
	let query = '/get_od_data.form?'
	query += `0x2000_2`; //product code
    
    for (let board_number = 1; board_number <= configuration.boards_count+1; board_number++)
    {
        /*if (board_number >= start_number) { query += "&"; }*/
        query += `&0x1027_${(board_number)}`; //board type
	}
	return fetch(query).then(response => response.text())
}

function form_name_tr(param_name)
{
    return $('<tr class="can_hide">').append($('<td>').text(param_name).addClass("name")).append($('<td>'));
}

let button_command_xhr = new XMLHttpRequest();
$(document).on('click', '#COMMAND_CLEAR_MTHRS', function()
{
	result = confirm(l100n.localize_string("COMMAND_CLEAR_MTHRS_confirm_question"));
	if (result == true)
	{
		var board_number = $(this).attr("board_number");
		var query = `/set_od_data.form?0x4${board_number-1}03_1=0x73726872`;
		button_command_xhr.open('GET', query, true);
		button_command_xhr.send();
	}
});

$(document).on('click', '#COMMAND_CLEAR_ENERGY', function()
{
	result = confirm(l100n.localize_string("COMMAND_CLEAR_ENERGY_confirm_question"));
	if (result == true)
	{
		var board_number = $(this).attr("board_number");
		var query = `/set_od_data.form?0x4${board_number-1}03_1=0x746e6372`;
		button_command_xhr.open('GET', query, true);
		button_command_xhr.send();
	}
});

})(this.mcu_common = {});
